program Menus;

{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Drawing.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Windows.Forms.dll'}

uses
  System.Reflection,
  System.Drawing,
  System.Drawing.Text,
  System.ComponentModel,
  System.Windows.Forms,
  System.Runtime.InteropServices;

type
  { .NET to VCL mapping }
  TLabel       = System.Windows.Forms.Label;
  TMainMenu    = System.Windows.Forms.MainMenu;
  TMenuItem    = System.Windows.Forms.MenuItem;
  TForm        = System.Windows.Forms.Form;
  TContextMenu = System.Windows.Forms.ContextMenu;
  TContainer   = System.ComponentModel.Container;
  TSize        = System.Drawing.Size;
  TPoint       = System.Drawing.Point;
  TFont        = System.Drawing.Font;
  TFontFamily  = System.Drawing.FontFamily;


  TFontSizes = (Small, Medium, Large);

const
  FontSizes: array[Low(TFontSizes)..High(TFontSizes)] of Single = (8, 12, 24);

type
  { Application main form }
//  [STAThread]
  TMainForm = class(TForm)
  private
    FComponents: TContainer;
    FFontSize: Single;
    procedure InitComponents;
    procedure FileExitClicked(Sender: TObject; Args: EventArgs);
    procedure FileOpenClicked(Sender: TObject; Args: EventArgs);
    procedure FormatFontClicked(Sender: TObject; Args: EventArgs);
    procedure FormatSizeClicked(Sender: TObject; Args: EventArgs);
  published
    Label1: TLabel;
    MainMenu: TMainMenu;
    Label1ContextMenu: TContextMenu;

    //Used to track which menu items are checked/unchecked
    mmiSansSerif: TMenuItem;
    mmiSerif: TMenuItem;
    mmiMonoSpace: TMenuItem;

    mmiSmall: TMenuItem;
    mmiMedium: TMenuItem;
    mmiLarge: TMenuItem;

    cmiSansSerif: TMenuItem;
    cmiSerif: TMenuItem;
    cmiMonoSpace: TMenuItem;

    cmiSmall: TMenuItem;
    cmiMedium: TMenuItem;
    cmiLarge: TMenuItem;

    miMainFormatFontChecked: TMenuItem;
    miMainFormatSizeChecked: TMenuItem;
    miContextFormatFontChecked: TMenuItem;
    miContextFormatSizeChecked: TMenuItem;

    currentFontFamily: FontFamily;
    monoSpaceFontFamily: FontFamily;
    sansSerifFontFamily: FontFamily;
    serifFontFamily: FontFamily;
  public
    constructor Create(Owner: TObject);
    destructor Destroy; override;
  end;

{ TMainForm }

constructor TMainForm.Create(Owner: TObject);
var
  miFile, miFormat, miFontFace, miFontSize: TMenuItem;
begin
  inherited Create;
  InitComponents;

  // Initialize Fonts - use generic fonts to avoid problems across
  // different versions of the OS
  monoSpaceFontFamily:= TFontFamily.Create(GenericFontFamilies.Monospace);
  sansSerifFontFamily:= TFontFamily.Create(GenericFontFamilies.SansSerif);
  serifFontFamily:= TFontFamily.Create(GenericFontFamilies.Serif);
  currentFontFamily:= sansSerifFontFamily;

  //Add File Menu
  miFile:= MainMenu.MenuItems.Add('&File');
  miFile.MenuItems.Add(TMenuItem.Create('&Open...', nil, Shortcut.CtrlO));
  miFile.MenuItems[0].Add_Click(FileOpenClicked);

  miFile.MenuItems.Add('-');     // Gives us a seperator

  miFile.MenuItems.Add(TMenuItem.Create('E&xit', nil, Shortcut.CtrlX));
  miFile.MenuItems[2].Add_Click(FileExitClicked);

  //Add Format Menu
  miFormat:= mainMenu.MenuItems.Add('F&ormat');

  //Font Face sub-menu
  mmiSansSerif:= TMenuItem.Create;
  mmiSansSerif.Text:= '&1. ' + sansSerifFontFamily.Name;
  mmiSansSerif.Add_Click(FormatFontClicked);
  mmiSansSerif.Checked:= True;
  mmiSansSerif.DefaultItem:= True;

  mmiSerif:= TMenuItem.Create;
  mmiSerif.Text:= '&2. ' + serifFontFamily.Name;
  mmiSerif.Add_Click(FormatFontClicked);

  mmiMonoSpace:= TMenuItem.Create;
  mmiMonoSpace.Text:= '&3. ' + monoSpaceFontFamily.Name;
  mmiMonoSpace.Add_Click(FormatFontClicked);

  //miFormat.MenuItems.Add('Font &Face', (new MenuItem[]{ mmiSansSerif, mmiSerif, mmiMonoSpace }));
  // the above line became the 6 lines below.
  miFontFace:= TMenuItem.Create;
  miFontFace.Text:= 'Font &Face';
  miFontFace.MenuItems.Add(mmiSansSerif);
  miFontFace.MenuItems.Add(mmiSerif);
  miFontFace.MenuItems.Add(mmiMonoSpace);
  miFormat.MenuItems.Add(miFontFace);

  //Font Size sub-menu
  mmiSmall:= TMenuItem.Create;
  mmiSmall.Text:= '&Small';
  mmiSmall.Add_Click(FormatSizeClicked);


  mmiMedium:= TMenuItem.Create; 
  mmiMedium.Text:= '&Medium';
  mmiMedium.Add_Click(FormatSizeClicked);
  mmiMedium.Checked:= True ;
  mmiMedium.DefaultItem:= True ;

  mmiLarge:= TMenuItem.Create;
  mmiLarge.Text:= '&Large';
  mmiLarge.Add_Click(FormatSizeClicked);

  //miFormat.MenuItems.Add('Font &Size',(new MenuItem[]{ mmiSmall, mmiMedium, mmiLarge }));
  miFontSize:= TMenuItem.Create;
  miFontSize.Text:= 'Font &Size';
  miFontSize.MenuItems.Add(mmiSmall);
  miFontSize.MenuItems.Add(mmiMedium);
  miFontSize.MenuItems.Add(mmiLarge);
  miFormat.MenuItems.Add(miFontSize);

  //Add Format to label context menu
  //Note have to add a clone because menus can't belong to 2 parents
  Label1ContextMenu.MenuItems.Add(miFormat.CloneMenu());

  // Set up the context menu items - we use these to check and uncheck items
  cmiSansSerif:= Label1ContextMenu.MenuItems[0].MenuItems[0].MenuItems[0];
  cmiSerif:= Label1ContextMenu.MenuItems[0].MenuItems[0].MenuItems[1];
  cmiMonoSpace:= label1ContextMenu.MenuItems[0].MenuItems[0].MenuItems[2];
  cmiSmall:= Label1ContextMenu.MenuItems[0].MenuItems[1].MenuItems[0];
  cmiMedium:= Label1ContextMenu.MenuItems[0].MenuItems[1].MenuItems[1];
  cmiLarge:= Label1ContextMenu.MenuItems[0].MenuItems[1].MenuItems[2];

  //We use these to track which menu items are checked
  //This is made more complex because we have both a menu and a context menu
  miMainFormatFontChecked:= mmiSansSerif;
  miMainFormatSizeChecked:= mmiMedium;
  miContextFormatFontChecked:= cmiSansSerif;
  miContextFormatSizeChecked:= cmiMedium;
end;

destructor TMainForm.Destroy;
begin
  if (FComponents <> nil) then
   FComponents.Dispose;
  inherited;
end;

procedure TMainForm.InitComponents;
begin
  SuspendLayout;

  FFontSize:= FontSizes[Medium];
  FComponents:= TContainer.Create;
  MainMenu:= TMainMenu.Create;

  Label1:= TLabel.Create;
  label1ContextMenu:= TContextMenu.Create;
  Text:= 'Menus ''R Us';
  AutoScaleBaseSize:= TSize.Create(5, 13);
  Menu:= MainMenu;
  ClientSize:= TSize.Create(392, 117);
  Label1.BackColor:= Color.LightSteelBlue;
  Label1.Location:= TPoint.create(16, 24);
  Label1.TabIndex:= 0;
  Label1.Anchor:= AnchorStyles(13);
  Label1.Size:= TSize.Create(360, 50);
  Label1.Text:= 'Right Click on me - I have a context menu!';
  Label1.ContextMenu:= Label1ContextMenu;
  Controls.Add (Label1);

  ResumeLayout(False);
end;

procedure TMainForm.FileExitClicked(Sender: TObject; Args: EventArgs);
begin
  Close;
end;

procedure TMainForm.FileOpenClicked(Sender: TObject; Args: EventArgs);
begin
  MessageBox.Show('And why would this open a file?');
end;

procedure TMainForm.FormatFontClicked(Sender: TObject; Args: EventArgs);
var
  miClicked: TMenuItem;
begin
  miClicked:= TMenuItem(Sender);

  miMainFormatFontChecked.Checked:= False;
  miContextFormatFontChecked.Checked:= False;

  if (miClicked = mmiSansSerif) or (miClicked = cmiSansSerif) then
  begin
    miMainFormatFontChecked:= mmiSansSerif;
    miContextFormatFontChecked:= cmiSansSerif;
    currentFontFamily:= sansSerifFontFamily;
  end
  else if (miClicked = mmiSerif) or (miClicked = cmiSerif) then
  begin
    miMainFormatFontChecked:= mmiSerif;
    miContextFormatFontChecked:= cmiSerif;
    currentFontFamily:= serifFontFamily;
  end
  else
  begin
    miMainFormatFontChecked:= mmiMonoSpace;
    miContextFormatFontChecked:= cmiMonoSpace;
    currentFontFamily:= monoSpaceFontFamily;
  end;

  miMainFormatFontChecked.Checked:= True;
  miContextFormatFontChecked.Checked:= True;
  Label1.Font:= TFont.Create(currentFontFamily, FFontSize);
end;

procedure TMainForm.FormatSizeClicked(Sender: TObject; Args: EventArgs);
var
  fontSizeString: string;
begin
  miMainFormatSizeChecked.Checked:= False;
  miContextFormatSizeChecked.Checked:= False;

  fontSizeString:= TMenuItem(Sender).Text;

  if (fontSizeString = '&Small') then
  begin
    miMainFormatSizeChecked:= mmiSmall;
    miContextFormatSizeChecked:= cmiSmall;
    FFontSize:= FontSizes[Small];
  end
  else if (fontSizeString = '&Large') then
  begin
    miMainFormatSizeChecked:= mmiLarge;
    miContextFormatSizeChecked:= cmiLarge;
    FFontSize:= FontSizes[Large];
  end
  else
  begin
    miMainFormatSizeChecked:= mmiMedium;
    miContextFormatSizeChecked:= cmiMedium;
    FFontSize:= FontSizes[Medium];
  end;

  miMainFormatSizeChecked.Checked:= True;
  miContextFormatSizeChecked.Checked:= True;

  Label1.Font:= TFont.Create(currentFontFamily, FFontSize);
end;

var
  MainForm: TMainForm;
begin
  MainForm:= TMainForm.Create(nil);
  Application.Run(MainForm);
  MainForm.Free;
end.
